//Include this file at the bottom of behavior_data.c
const BehaviorScript bhvSpinAirborneWarp[] = {
	BREAK(),
};

const BehaviorScript bhvStar[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 1),
	CALL_NATIVE( bhv_init_room),
	CALL_NATIVE( bhv_collect_star_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_collect_star_loop),
	END_LOOP(),
};

const BehaviorScript bhvHiddenRedCoinStar[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 16385),
	CALL_NATIVE( bhv_hidden_red_coin_star_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_hidden_red_coin_star_loop),
	END_LOOP(),
};

const BehaviorScript bhvKoopa[] = {
	BEGIN(OBJ_LIST_PUSHABLE),
	OR_INT(oFlags, 8257),
	DROP_TO_FLOOR(),
	LOAD_ANIMATIONS(10022, 100733796),
	ANIMATE(9),
	SET_HOME(),
	SET_OBJ_PHYSICS(50, 65136, 0, 0, 1000, 200, 0, 0),
	SCALE(0, 150),
	SET_FLOAT(oUkikiTauntsToBeDone, 1),
	CALL_NATIVE( bhv_koopa_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_koopa_update),
	END_LOOP(),
};

const BehaviorScript bhvKoopaRaceEndpoint[] = {
	BEGIN(OBJ_LIST_DEFAULT),
	OR_INT(oFlags, 65),
	DROP_TO_FLOOR(),
	SPAWN_CHILD_WITH_PARAM(0, 106, 318785016),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_koopa_race_endpoint_update),
	END_LOOP(),
};

const BehaviorScript bhvRedCoin[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 1),
	BILLBOARD(),
	SET_INT(oIntangibleTimer, 0),
	SET_INT(oAnimState, 65535),
	CALL_NATIVE( bhv_init_room),
	CALL_NATIVE( bhv_red_coin_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_red_coin_loop),
		ADD_INT(oAnimState, 1),
	END_LOOP(),
};

const BehaviorScript bhvCannonClosed[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 16385),
	LOAD_COLLISION_DATA(col_cannon_lid_seg8_dl_080048E0_0xa861b0),
	SET_HOME(),
	CALL_NATIVE( bhv_cannon_closed_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_cannon_closed_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvBobombBuddyOpensCannon[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 25673),
	LOAD_ANIMATIONS(10022, 134363500),
	SET_INTERACT_TYPE(8388608),
	DROP_TO_FLOOR(),
	SET_HITBOX(100, 60),
	ANIMATE(0),
	SET_INT(oYoshiChosenHome, 1),
	SET_HOME(),
	CALL_NATIVE( bhv_bobomb_buddy_init),
	BEGIN_LOOP(),
		SET_INT(oIntangibleTimer, 0),
		CALL_NATIVE( bhv_bobomb_buddy_loop),
	END_LOOP(),
};

const BehaviorScript bhvExclamationBox[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 9),
	LOAD_COLLISION_DATA(col_exclamation_box_geo_0xaa77d8),
	OR_INT(oFlags, 1),
	SET_FLOAT(oCollisionDistance, 300),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_exclamation_box_loop),
	END_LOOP(),
};

const BehaviorScript bhvBubba[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8265),
	SET_HOME(),
	SET_OBJ_PHYSICS(200, 65136, 65486, 1000, 1000, 0, 0, 0),
	SCALE(0, 50),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_bubba_loop),
	END_LOOP(),
};

const BehaviorScript bhvCoinFormation[] = {
	BEGIN(OBJ_LIST_SPAWNER),
	OR_INT(oFlags, 65),
	CALL_NATIVE( bhv_coin_formation_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_coin_formation_loop),
	END_LOOP(),
};

const BehaviorScript bhvGoombaTripletSpawner[] = {
	BEGIN(OBJ_LIST_PUSHABLE),
	OR_INT(oFlags, 65),
	DROP_TO_FLOOR(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_goomba_triplet_spawner_update),
	END_LOOP(),
};

const BehaviorScript bhvPiranhaPlant[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8265),
	LOAD_ANIMATIONS(10022, 100778780),
	ANIMATE(0),
	SET_INTERACT_TYPE(8),
	SET_HITBOX(100, 200),
	SET_HURTBOX(50, 200),
	SET_INT(oIntangibleTimer, 0),
	SET_INT(oDamageOrCoinValue, 3),
	SET_INT(oNumLootCoins, 5),
	SPAWN_CHILD(168, 318772268),
	SET_FLOAT(oDrawingDistance, 2000),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_piranha_plant_loop),
	END_LOOP(),
};

const BehaviorScript bhvGoomba[] = {
	BEGIN(OBJ_LIST_PUSHABLE),
	OR_INT(oFlags, 8265),
	DROP_TO_FLOOR(),
	LOAD_ANIMATIONS(10022, 134339148),
	SET_HOME(),
	SET_OBJ_PHYSICS(40, 65136, 65486, 1000, 1000, 0, 0, 0),
	CALL_NATIVE( bhv_goomba_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_goomba_update),
	END_LOOP(),
};

const BehaviorScript bhvBobomb[] = {
	BEGIN(OBJ_LIST_DESTRUCTIVE),
	OR_INT(oFlags, 25673),
	LOAD_ANIMATIONS(10022, 134363500),
	DROP_TO_FLOOR(),
	ANIMATE(0),
	SET_INT(oIntangibleTimer, 0),
	SET_HOME(),
	CALL_NATIVE( bhv_bobomb_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_bobomb_loop),
	END_LOOP(),
};

const BehaviorScript bhv1Up[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 1),
	BILLBOARD(),
	SET_HITBOX_WITH_OFFSET(30, 30, 0),
	SET_FLOAT(oGraphYOffset, 30),
	CALL_NATIVE( bhv_1up_init),
	BEGIN_LOOP(),
		SET_INT(oIntangibleTimer, 0),
		CALL_NATIVE( bhv_1up_loop),
	END_LOOP(),
};

const BehaviorScript bhvTree[] = {
	BEGIN(OBJ_LIST_POLELIKE),
	BILLBOARD(),
	OR_INT(oFlags, 1),
	SET_INT(oInteractType, 64),
	SET_HITBOX(80, 500),
	SET_INT(oIntangibleTimer, 0),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_pole_base_loop),
	END_LOOP(),
};

const BehaviorScript bhvButterfly[] = {
	BEGIN(OBJ_LIST_DEFAULT),
	OR_INT(oFlags, 9),
	LOAD_ANIMATIONS(10022, 50353840),
	DROP_TO_FLOOR(),
	SET_FLOAT(oGraphYOffset, 5),
	CALL_NATIVE( bhv_butterfly_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_butterfly_loop),
	END_LOOP(),
};

const BehaviorScript bhvTripletButterfly[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8265),
	LOAD_ANIMATIONS(10022, 50353840),
	ANIMATE(0),
	HIDE(),
	SET_HOME(),
	SET_OBJ_PHYSICS(0, 0, 0, 0, 1000, 200, 0, 0),
	SET_FLOAT(oUkikiTauntsToBeDone, 1),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_triplet_butterfly_update),
	END_LOOP(),
};

const BehaviorScript bhvBlueCoinSwitch[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_blue_coin_switch_geo_0xa826f8),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_blue_coin_switch_loop),
	END_LOOP(),
};

const BehaviorScript bhvHiddenBlueCoin[] = {
	BEGIN(OBJ_LIST_LEVEL),
	SET_INT(oInteractType, 16),
	OR_INT(oFlags, 193),
	BILLBOARD(),
	SET_HITBOX(100, 64),
	SET_INT(oDamageOrCoinValue, 5),
	SET_INT(oIntangibleTimer, 0),
	SET_INT(oAnimState, 65535),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_hidden_blue_coin_loop),
		ADD_INT(oAnimState, 1),
	END_LOOP(),
};

const BehaviorScript bhvWoodenPost[] = {
	BEGIN(OBJ_LIST_SURFACE),
	LOAD_COLLISION_DATA(col_wooden_post_geo_0xa0bdf0),
	OR_INT(oFlags, 8257),
	SET_OBJ_PHYSICS(0, 65136, 65486, 1000, 1000, 200, 0, 0),
	SET_INT(oNumLootCoins, 5),
	DROP_TO_FLOOR(),
	SET_HOME(),
	SCALE(0, 50),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_wooden_post_update),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvMessagePanel[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_wooden_signpost_geo_0xae01d0),
	SET_INTERACT_TYPE(8388608),
	SET_INT(oInteractionSubtype, 4096),
	DROP_TO_FLOOR(),
	SET_HITBOX(150, 80),
	SET_INT(oUkikiTauntsToBeDone, 0),
	BEGIN_LOOP(),
		SET_INT(oIntangibleTimer, 0),
		CALL_NATIVE( load_object_collision_model),
		SET_INT(oInteractStatus, 0),
	END_LOOP(),
};

const BehaviorScript RM_Scroll_Texture[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 1),
	BEGIN_LOOP(),
		CALL_NATIVE( Func_Custom_0x80401718),
	END_LOOP(),
};

const BehaviorScript bhvHiddenStarTrigger[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 1),
	SET_HITBOX(100, 100),
	SET_INT(oIntangibleTimer, 0),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_hidden_star_trigger_loop),
	END_LOOP(),
};

const BehaviorScript bhvHiddenStar[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 16385),
	CALL_NATIVE( bhv_hidden_star_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_hidden_star_loop),
	END_LOOP(),
};

const BehaviorScript bhvFloorSwitchHiddenObjects[] = {
	BEGIN(OBJ_LIST_SURFACE),
	SET_INT(oBehParams2ndByte, 2),
	GOTO( Bhv_Custom_0x13001488),
};

const BehaviorScript Bhv_Custom_0x13001488[] = {
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_purple_switch_geo_0xa8e008),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_purple_switch_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvHiddenObject[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_breakable_box_geo_0xa945d0),
	SET_FLOAT(oCollisionDistance, 300),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_hidden_object_loop),
	END_LOOP(),
};

const BehaviorScript bhvChuckya[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 1097),
	LOAD_ANIMATIONS(10022, 134266992),
	ANIMATE(5),
	SET_INT(oInteractType, 2),
	SET_HITBOX(150, 100),
	SET_OBJ_PHYSICS(30, 65136, 65486, 1000, 1000, 200, 0, 0),
	SPAWN_OBJ(0, 318768516),
	SET_INT(oNumLootCoins, 5),
	SET_INT(oIntangibleTimer, 0),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_chuckya_loop),
	END_LOOP(),
};

const BehaviorScript bhvChainChomp[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8393),
	DROP_TO_FLOOR(),
	LOAD_ANIMATIONS(10022, 100815224),
	ANIMATE(0),
	SET_OBJ_PHYSICS(0, 65136, 65486, 0, 1000, 200, 0, 0),
	HIDE(),
	SET_HOME(),
	SET_FLOAT(oGraphYOffset, 240),
	SCALE(0, 200),
	SPAWN_CHILD_WITH_PARAM(0, 107, 318785564),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_chain_chomp_update),
	END_LOOP(),
};

const BehaviorScript bhvSmallWhomp[] = {
	BEGIN(OBJ_LIST_SURFACE),
	SET_INT(oNumLootCoins, 5),
	OR_INT(oFlags, 8265),
	LOAD_ANIMATIONS(10022, 100796932),
	LOAD_COLLISION_DATA(col_whomp_geo_0xa2a36c),
	ANIMATE(0),
	SET_OBJ_PHYSICS(0, 65136, 65486, 0, 0, 200, 0, 0),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_whomp_loop),
	END_LOOP(),
};

const BehaviorScript bhvBreakableBox[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_breakable_box_geo_0xa945d0),
	SET_FLOAT(oCollisionDistance, 500),
	CALL_NATIVE( bhv_init_room),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_breakable_box_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvHidden1upInPoleSpawner[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 1),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_1up_hidden_in_pole_spawner_loop),
	END_LOOP(),
};

const BehaviorScript bhvBobombBuddy[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 9289),
	LOAD_ANIMATIONS(10022, 134363500),
	SET_INTERACT_TYPE(8388608),
	DROP_TO_FLOOR(),
	SET_HITBOX(100, 60),
	ANIMATE(0),
	SET_INT(oYoshiChosenHome, 0),
	SET_HOME(),
	CALL_NATIVE( bhv_bobomb_buddy_init),
	BEGIN_LOOP(),
		SET_INT(oIntangibleTimer, 0),
		CALL_NATIVE( bhv_bobomb_buddy_loop),
	END_LOOP(),
};

const BehaviorScript bhvKingBobomb[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8393),
	LOAD_ANIMATIONS(10022, 83951152),
	SET_INT(oInteractType, 2),
	SET_HITBOX(100, 100),
	SET_OBJ_PHYSICS(30, 65136, 65486, 1000, 1000, 200, 0, 0),
	SET_INT(oIntangibleTimer, 0),
	DROP_TO_FLOOR(),
	SET_HOME(),
	SPAWN_OBJ(0, 318767700),
	SET_INT(oHealth, 3),
	SET_INT(oDamageOrCoinValue, 1),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_king_bobomb_loop),
	END_LOOP(),
};

const BehaviorScript bhvWarpPipe[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 9),
	SET_INT(oInteractType, 8192),
	LOAD_COLLISION_DATA(col_warp_pipe_geo_0xabbf18),
	SET_FLOAT(oDrawingDistance, 16000),
	SET_INT(oIntangibleTimer, 0),
	SET_HITBOX(70, 50),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_warp_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvBreakableBoxSmall[] = {
	BEGIN(OBJ_LIST_DESTRUCTIVE),
	OR_INT(oFlags, 1097),
	DROP_TO_FLOOR(),
	SET_HOME(),
	CALL_NATIVE( bhv_breakable_box_small_init),
	BEGIN_LOOP(),
		SET_INT(oIntangibleTimer, 0),
		CALL_NATIVE( bhv_breakable_box_small_loop),
	END_LOOP(),
};

const BehaviorScript bhvTreasureChestsJrb[] = {
	BEGIN(OBJ_LIST_DEFAULT),
	OR_INT(oFlags, 1),
	DROP_TO_FLOOR(),
	CALL_NATIVE( bhv_treasure_chest_jrb_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_treasure_chest_jrb_loop),
	END_LOOP(),
};

const BehaviorScript bhvFadingWarp[] = {
	BEGIN(OBJ_LIST_LEVEL),
	SET_INT(oInteractionSubtype, 1),
	OR_INT(oFlags, 9),
	SET_INT(oInteractType, 8192),
	SET_INT(oIntangibleTimer, 0),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_fading_warp_loop),
	END_LOOP(),
};

const BehaviorScript bhvFireSpitter[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8257),
	BILLBOARD(),
	SCALE(0, 40),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_fire_spitter_update),
	END_LOOP(),
};

const BehaviorScript Bhv_Custom_0x13005714[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_custom_DL_07007070_0x126ee60),
	SET_FLOAT(oCollisionDistance, 32767),
	BEGIN_LOOP(),
		ADD_INT(oFaceAngleYaw, 256),
		SET_INT(oAngleVelYaw, 256),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvSnufit[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8265),
	SET_HOME(),
	SET_OBJ_PHYSICS(30, 0, 65486, 0, 0, 0, 0, 0),
	CALL_NATIVE( bhv_init_room),
	BEGIN_LOOP(),
		SET_INT(oUkikiTauntsToBeDone, 0),
		CALL_NATIVE( bhv_snufit_loop),
	END_LOOP(),
};

const BehaviorScript bhvHeaveHo[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 9289),
	LOAD_ANIMATIONS(10022, 83972940),
	ANIMATE(0),
	SET_OBJ_PHYSICS(200, 65136, 65486, 1000, 1000, 600, 0, 0),
	SPAWN_OBJ(0, 318772644),
	SET_INT(oInteractType, 2),
	SET_INT(oInteractionSubtype, 516),
	SET_HITBOX(120, 100),
	SET_HOME(),
	SET_INT(oIntangibleTimer, 0),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_heave_ho_loop),
	END_LOOP(),
};

const BehaviorScript bhvScuttlebug[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 73),
	LOAD_ANIMATIONS(10022, 100749412),
	ANIMATE(0),
	SET_OBJ_PHYSICS(80, 65136, 65486, 0, 0, 200, 0, 0),
	SET_HOME(),
	CALL_NATIVE( bhv_init_room),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_scuttlebug_loop),
	END_LOOP(),
};

const BehaviorScript bhvMrI[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 75),
	SET_HOME(),
	SPAWN_CHILD(102, 318767244),
	SET_MODEL(103),
	BILLBOARD(),
	CALL_NATIVE( bhv_init_room),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_mr_i_loop),
	END_LOOP(),
};

const BehaviorScript bhvDoor[] = {
	BEGIN(OBJ_LIST_SURFACE),
	SET_INT(oInteractType, 4),
	OR_INT(oFlags, 201),
	LOAD_ANIMATIONS(10022, 50419392),
	ANIMATE(0),
	LOAD_COLLISION_DATA(col_haunted_door_geo_0xacf2c8),
	SET_HITBOX(80, 100),
	SET_INT(oIntangibleTimer, 0),
	SET_FLOAT(oCollisionDistance, 1000),
	SET_HOME(),
	CALL_NATIVE( bhv_door_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_door_loop),
	END_LOOP(),
};

const BehaviorScript bhvGhostHuntBoo[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8265),
	SET_INT(oIntangibleTimer, 0),
	SET_HOME(),
	SET_INT(oDamageOrCoinValue, 2),
	SET_HITBOX(140, 80),
	SET_HURTBOX(40, 60),
	SET_FLOAT(oGraphYOffset, 30),
	CALL_NATIVE( bhv_init_room),
	SPAWN_CHILD(116, 318769288),
	SET_OBJ_PHYSICS(30, 0, 65486, 1000, 1000, 200, 0, 0),
	CALL_NATIVE( bhv_boo_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_boo_loop),
	END_LOOP(),
};

const BehaviorScript bhvGhostHuntBigBoo[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8265),
	SET_HOME(),
	SET_OBJ_PHYSICS(30, 0, 65486, 1000, 1000, 200, 0, 0),
	CALL_NATIVE( bhv_init_room),
	CALL_NATIVE( bhv_boo_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_big_boo_loop),
	END_LOOP(),
};

const BehaviorScript bhvMadPiano[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8257),
	DROP_TO_FLOOR(),
	LOAD_ANIMATIONS(10022, 83925780),
	SET_OBJ_PHYSICS(40, 0, 65486, 1000, 1000, 200, 0, 0),
	SET_HOME(),
	ADD_INT(oMoveAngleYaw, 16384),
	CALL_NATIVE( bhv_init_room),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_mad_piano_update),
	END_LOOP(),
};

const BehaviorScript bhvFlame[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 1),
	BILLBOARD(),
	SET_HOME(),
	SCALE(0, 700),
	SET_INTERACT_TYPE(262144),
	SET_HITBOX_WITH_OFFSET(50, 25, 25),
	SET_INT(oIntangibleTimer, 0),
	CALL_NATIVE( bhv_init_room),
	BEGIN_LOOP(),
		SET_INT(oInteractStatus, 0),
		ANIMATE_TEXTURE(oAnimState, 2),
	END_LOOP(),
};

const BehaviorScript bhvHauntedChair[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8257),
	DROP_TO_FLOOR(),
	LOAD_ANIMATIONS(10022, 83908484),
	ANIMATE(0),
	SET_OBJ_PHYSICS(40, 0, 65486, 1000, 1000, 200, 0, 0),
	SET_HOME(),
	CALL_NATIVE( bhv_init_room),
	CALL_NATIVE( bhv_haunted_chair_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_haunted_chair_loop),
	END_LOOP(),
};

const BehaviorScript Bhv_Custom_0x130058c8[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 1),
	SET_HITBOX(100, 100),
	SET_INT(oIntangibleTimer, 0),
	BEGIN_LOOP(),
		SPAWN_CHILD(0, 318778096),
		CALL_NATIVE( Func_Custom_0x80406078),
	END_LOOP(),
};

const BehaviorScript bhvRecoveryHeart[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 8257),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_recovery_heart_loop),
	END_LOOP(),
};

const BehaviorScript bhvPushableMetalBox[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_metal_box_geo_0xaa6488),
	SET_FLOAT(oCollisionDistance, 500),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_pushable_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvFlyGuy[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8257),
	LOAD_ANIMATIONS(10022, 134290020),
	ANIMATE(0),
	SET_HOME(),
	SET_OBJ_PHYSICS(50, 0, 0, 0, 1000, 600, 0, 0),
	CALL_NATIVE( bhv_init_room),
	SET_INT(oInteractionSubtype, 128),
	SET_FLOAT(oGraphYOffset, 30),
	SCALE(0, 150),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_fly_guy_update),
	END_LOOP(),
};

const BehaviorScript bhvJumpingBox[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 1089),
	SET_OBJ_PHYSICS(30, 65136, 65486, 1000, 1000, 600, 0, 0),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_jumping_box_loop),
	END_LOOP(),
};

const BehaviorScript bhvCirclingAmp[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8259),
	LOAD_ANIMATIONS(10022, 134234164),
	ANIMATE(0),
	SET_FLOAT(oGraphYOffset, 40),
	SET_INT(oIntangibleTimer, 0),
	CALL_NATIVE( bhv_circling_amp_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_circling_amp_loop),
	END_LOOP(),
};

const BehaviorScript bhvCheckerboardElevatorGroup[] = {
	BEGIN(OBJ_LIST_SPAWNER),
	OR_INT(oFlags, 1),
	CALL_NATIVE( bhv_checkerboard_elevator_group_init),
	DELAY(1),
	DEACTIVATE(),
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 65),
	LOAD_COLLISION_DATA(col_None_0xa8ef70),
	CALL_NATIVE( bhv_checkerboard_platform_init),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_checkerboard_platform_loop),
	END_LOOP(),
};

const BehaviorScript bhvBigBully[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 9),
	LOAD_ANIMATIONS(10022, 83904268),
	DROP_TO_FLOOR(),
	SET_HOME(),
	CALL_NATIVE( bhv_big_bully_init),
	BEGIN_LOOP(),
		SET_INT(oIntangibleTimer, 0),
		CALL_NATIVE( bhv_bully_loop),
	END_LOOP(),
};

const BehaviorScript Bhv_Custom_0x13005740[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 73),
	LOAD_COLLISION_DATA(col_custom_DL_0700a090_0x12720d0),
	ADD_FLOAT(oPosY, 5),
	SET_FLOAT(oCollisionDistance, 2000),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_lll_sinking_rectangular_platform_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript Bhv_Custom_0x130057d8[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_custom_DL_07010780_0x12785d0),
	SET_FLOAT(oCollisionDistance, 32767),
	BEGIN_LOOP(),
		ADD_INT(oFaceAngleYaw, 256),
		SET_INT(oAngleVelYaw, 256),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript Bhv_Custom_0x13005874[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 73),
	LOAD_COLLISION_DATA(col_custom_DL_07008dc0_0x1270c10),
	ADD_FLOAT(oPosY, 5),
	SET_FLOAT(oCollisionDistance, 2000),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_lll_sinking_square_platforms_loop),
		CALL_NATIVE( bhv_lll_sinking_rock_block_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript Bhv_Custom_0x13005804[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 73),
	LOAD_COLLISION_DATA(col_custom_DL_07011ab0_0x1279af0),
	ADD_FLOAT(oPosY, 5),
	SET_HOME(),
	CALL_NATIVE( bhv_platform_normals_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_tilting_inverted_pyramid_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript Bhv_Custom_0x13005774[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 73),
	LOAD_COLLISION_DATA(col_custom_DL_0700e3d0_0x1276250),
	ADD_FLOAT(oPosY, 5),
	SET_FLOAT(oCollisionDistance, 2000),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_lll_sinking_square_platforms_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript Bhv_Custom_0x1300583c[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_custom_DL_0700bfe0_0x1273f60),
	SET_HOME(),
	SET_FLOAT(oCollisionDistance, 2000),
	CALL_NATIVE( bhv_lll_rolling_log_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_rolling_log_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript Bhv_Custom_0x130057a8[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 9),
	LOAD_COLLISION_DATA(col_custom_DL_0700efd0_0x1276fe0),
	ADD_FLOAT(oPosY, 65486),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_lll_sinking_rock_block_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvSmallBully[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 9),
	LOAD_ANIMATIONS(10022, 83904268),
	DROP_TO_FLOOR(),
	SET_HOME(),
	CALL_NATIVE( bhv_small_bully_init),
	BEGIN_LOOP(),
		SET_INT(oIntangibleTimer, 0),
		CALL_NATIVE( bhv_bully_loop),
	END_LOOP(),
};

const BehaviorScript bhvFlamethrower[] = {
	BEGIN(OBJ_LIST_DEFAULT),
	OR_INT(oFlags, 73),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_flamethrower_loop),
	END_LOOP(),
};

const BehaviorScript bhvBoo[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	SET_INT(oBehParams2ndByte, 1),
	GOTO( Bhv_Custom_0x13002808),
};

const BehaviorScript Bhv_Custom_0x13002808[] = {
	OR_INT(oFlags, 8265),
	SET_INT(oIntangibleTimer, 0),
	SET_HOME(),
	SET_INT(oDamageOrCoinValue, 2),
	SET_HITBOX(140, 80),
	SET_HURTBOX(40, 60),
	SET_FLOAT(oGraphYOffset, 30),
	CALL_NATIVE( bhv_init_room),
	SPAWN_CHILD(116, 318769288),
	SET_OBJ_PHYSICS(30, 0, 65486, 1000, 1000, 200, 0, 0),
	CALL_NATIVE( bhv_boo_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_boo_loop),
	END_LOOP(),
};

const BehaviorScript bhvClamShell[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8265),
	DROP_TO_FLOOR(),
	LOAD_ANIMATIONS(10022, 83892036),
	SET_FLOAT(oGraphYOffset, 10),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_clam_loop),
	END_LOOP(),
};

const BehaviorScript bhvHomingAmp[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8267),
	LOAD_ANIMATIONS(10022, 134234164),
	ANIMATE(0),
	SET_FLOAT(oGraphYOffset, 40),
	SET_INT(oIntangibleTimer, 0),
	CALL_NATIVE( bhv_homing_amp_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_homing_amp_loop),
	END_LOOP(),
};

const BehaviorScript bhvBigChillBully[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 9),
	LOAD_ANIMATIONS(10022, 100678036),
	DROP_TO_FLOOR(),
	SET_HOME(),
	SET_INT(oUkikiTauntsToBeDone, 16),
	CALL_NATIVE( bhv_big_bully_init),
	BEGIN_LOOP(),
		SET_INT(oIntangibleTimer, 0),
		CALL_NATIVE( bhv_bully_loop),
	END_LOOP(),
};

const BehaviorScript Bhv_Custom_0x130056bc[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_custom_DL_07002a20_0x126a520),
	SET_FLOAT(oCollisionDistance, 32767),
	BEGIN_LOOP(),
		ADD_INT(oFaceAngleYaw, 256),
		SET_INT(oAngleVelYaw, 256),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvWhompKingBoss[] = {
	BEGIN(OBJ_LIST_SURFACE),
	SET_INT(oBehParams2ndByte, 1),
	SET_INT(oHealth, 3),
	GOTO( Bhv_Custom_0x13002bd4),
};

const BehaviorScript Bhv_Custom_0x13002bd4[] = {
	OR_INT(oFlags, 8265),
	LOAD_ANIMATIONS(10022, 100796932),
	LOAD_COLLISION_DATA(col_whomp_geo_0xa2a36c),
	ANIMATE(0),
	SET_OBJ_PHYSICS(0, 65136, 65486, 0, 0, 200, 0, 0),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_whomp_loop),
	END_LOOP(),
};

const BehaviorScript Bhv_Custom_0x130056e8[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_custom_DL_07004a10_0x126c6c0),
	SET_FLOAT(oCollisionDistance, 32767),
	BEGIN_LOOP(),
		ADD_INT(oFaceAngleYaw, 256),
		SET_INT(oAngleVelYaw, 256),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvOneCoin[] = {
	BEGIN(OBJ_LIST_LEVEL),
	SET_INT(oBehParams2ndByte, 1),
	GOTO( Bhv_Custom_0x13000920),
};

const BehaviorScript Bhv_Custom_0x13000920[] = {
	BILLBOARD(),
	OR_INT(oFlags, 65),
	CALL_NATIVE( bhv_yellow_coin_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_yellow_coin_loop),
	END_LOOP(),
};

const BehaviorScript bhvBalconyBigBoo[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	SET_INT(oBehParams2ndByte, 2),
	SET_INT(oWigglerTextStatus, 10),
	GOTO( Bhv_Custom_0x13002794),
};

const BehaviorScript Bhv_Custom_0x13002794[] = {
	OR_INT(oFlags, 8265),
	SET_HOME(),
	SET_OBJ_PHYSICS(30, 0, 65486, 1000, 1000, 200, 0, 0),
	CALL_NATIVE( bhv_init_room),
	CALL_NATIVE( bhv_boo_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_big_boo_loop),
	END_LOOP(),
};

const BehaviorScript bhvStaticObject[] = {
	BEGIN(OBJ_LIST_DEFAULT),
	OR_INT(oFlags, 1),
	BREAK(),
};

const BehaviorScript bhvPoleGrabbing[] = {
	BEGIN(OBJ_LIST_POLELIKE),
	OR_INT(oFlags, 1),
	SET_INT(oInteractType, 64),
	SET_HITBOX(80, 1500),
	CALL_NATIVE( bhv_pole_init),
	SET_INT(oIntangibleTimer, 0),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_pole_base_loop),
	END_LOOP(),
};

const BehaviorScript bhvWigglerHead[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8257),
	DROP_TO_FLOOR(),
	LOAD_ANIMATIONS(10022, 83946636),
	SET_HOME(),
	SET_OBJ_PHYSICS(60, 65136, 0, 1000, 1000, 200, 0, 0),
	HIDE(),
	SCALE(0, 400),
	SET_FLOAT(oUkikiTauntsToBeDone, 5000),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_wiggler_update),
	END_LOOP(),
};

const BehaviorScript bhvEnemyLakitu[] = {
	BEGIN(OBJ_LIST_PUSHABLE),
	OR_INT(oFlags, 8257),
	LOAD_ANIMATIONS(10022, 83969236),
	ANIMATE(0),
	SET_HOME(),
	SET_OBJ_PHYSICS(40, 0, 65486, 0, 0, 200, 0, 0),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_enemy_lakitu_update),
	END_LOOP(),
};

const BehaviorScript bhvYellowCoin[] = {
	BEGIN(OBJ_LIST_LEVEL),
	BILLBOARD(),
	OR_INT(oFlags, 65),
	CALL_NATIVE( bhv_yellow_coin_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_yellow_coin_loop),
	END_LOOP(),
};

const BehaviorScript bhvEyerokBoss[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8257),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_eyerok_boss_loop),
	END_LOOP(),
};

const BehaviorScript bhvAirborneWarp[] = {
	BREAK(),
};

const BehaviorScript bhvThwomp[] = {
	BEGIN(OBJ_LIST_SURFACE),
	LOAD_COLLISION_DATA(col_thwomp_geo_0x86c6c0),
	OR_INT(oFlags, 73),
	DROP_TO_FLOOR(),
	ADD_FLOAT(oPosY, 1),
	SCALE(0, 140),
	SET_HOME(),
	SET_FLOAT(oDrawingDistance, 4000),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_grindel_thwomp_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvDeathWarp[] = {
	BREAK(),
};

const BehaviorScript bhvWarp[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 9),
	SET_INT(oInteractType, 8192),
	SET_INT(oIntangibleTimer, 0),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_warp_loop),
	END_LOOP(),
};

const BehaviorScript bhvInstantActiveWarp[] = {
	BREAK(),
};

const BehaviorScript bhvAirborneStarCollectWarp[] = {
	BREAK(),
};

const BehaviorScript bhvHidden1upTrigger[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 1),
	SET_HITBOX(100, 100),
	SET_INT(oIntangibleTimer, 0),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_1up_hidden_trigger_loop),
	END_LOOP(),
};

const BehaviorScript bhvBirdsSoundLoop[] = {
	BEGIN(OBJ_LIST_DEFAULT),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_birds_sound_loop),
	END_LOOP(),
};

const BehaviorScript bhvWaterfallSoundLoop[] = {
	BEGIN(OBJ_LIST_DEFAULT),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_waterfall_sound_loop),
	END_LOOP(),
};

const BehaviorScript bhvBird[] = {
	BEGIN(OBJ_LIST_DEFAULT),
	OR_INT(oFlags, 8265),
	LOAD_ANIMATIONS(10022, 83888616),
	ANIMATE(0),
	HIDE(),
	SCALE(0, 70),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_bird_update),
	END_LOOP(),
};

const BehaviorScript bhvLaunchStarCollectWarp[] = {
	BREAK(),
};

const BehaviorScript bhvPaintingStarCollectWarp[] = {
	BREAK(),
};

const BehaviorScript bhvPaintingDeathWarp[] = {
	BREAK(),
};

const BehaviorScript Bhv_Custom_0x130058b0[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 1),
	SET_INT(oUkikiTauntsToBeDone, 1),
	CALL_NATIVE( Func_Custom_0x80406000),
	BREAK(),
};

const BehaviorScript bhvBooWithCage[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 8265),
	SET_HOME(),
	SET_INT(oDamageOrCoinValue, 3),
	SET_HURTBOX(80, 120),
	SET_HITBOX(180, 140),
	SET_FLOAT(oGraphYOffset, 60),
	SET_OBJ_PHYSICS(30, 0, 65486, 1000, 1000, 200, 0, 0),
	CALL_NATIVE( bhv_boo_with_cage_init),
	CALL_NATIVE( bhv_init_room),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_boo_with_cage_loop),
	END_LOOP(),
};

const BehaviorScript bhvLaunchDeathWarp[] = {
	BREAK(),
};

const BehaviorScript bhvAmbientSounds[] = {
	BEGIN(OBJ_LIST_DEFAULT),
	CALL_NATIVE( bhv_ambient_sounds_init),
	BEGIN_LOOP(),
	END_LOOP(),
};

const BehaviorScript bhvCourtyardBooTriplet[] = {
	BEGIN(OBJ_LIST_DEFAULT),
	DISABLE_RENDERING(),
};

const BehaviorScript bhvCapSwitch[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 9),
	LOAD_COLLISION_DATA(col_cap_switch_geo_0x913db0),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_cap_switch_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvWaterLevelDiamond[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	SET_HITBOX(70, 30),
	SET_FLOAT(oCollisionDistance, 200),
	SET_INT(oIntangibleTimer, 0),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_water_level_diamond_loop),
	END_LOOP(),
};

const BehaviorScript bhvInitializeChangingWaterLevel[] = {
	BEGIN(OBJ_LIST_DEFAULT),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_init_changing_water_level_loop),
	END_LOOP(),
};

const BehaviorScript bhvSquarishPathMoving[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_geo_bitdw_000558_0xff0960),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_squarish_path_moving_loop),
	END_LOOP(),
};

const BehaviorScript bhvSeesawPlatform[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 8265),
	CALL_NATIVE( bhv_seesaw_platform_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_seesaw_platform_update),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvSlidingPlatform2[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 65),
	SET_HOME(),
	CALL_NATIVE( bhv_sliding_plat_2_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_sliding_plat_2_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvFerrisWheelAxle[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	ADD_INT(oMoveAngleYaw, 16384),
	CALL_NATIVE( bhv_ferris_wheel_axle_init),
	BEGIN_LOOP(),
		ADD_INT(oFaceAngleRoll, 400),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvAnimatesOnFloorSwitchPress[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 65),
	SET_FLOAT(oCollisionDistance, 8000),
	CALL_NATIVE( bhv_animates_on_floor_switch_press_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_animates_on_floor_switch_press_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvFloorSwitchAnimatesObject[] = {
	BEGIN(OBJ_LIST_SURFACE),
	SET_INT(oBehParams2ndByte, 1),
	GOTO( Bhv_Custom_0x13001488),
};

const BehaviorScript Bhv_Custom_0x13001488[] = {
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_purple_switch_geo_0xa8e008),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_purple_switch_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvBowserCourseRedCoinStar[] = {
	BEGIN(OBJ_LIST_LEVEL),
	OR_INT(oFlags, 16385),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_bowser_course_red_coin_star_loop),
	END_LOOP(),
};

const BehaviorScript bhvPlatformOnTrack[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 8257),
	SET_OBJ_PHYSICS(50, 65436, 65486, 100, 1000, 200, 0, 0),
	CALL_NATIVE( bhv_init_room),
	CALL_NATIVE( bhv_platform_on_track_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_platform_on_track_update),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvBitfsTiltingInvertedPyramid[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 73),
	LOAD_COLLISION_DATA(col_bitfs_geo_0006C0_0x1020f08),
	SET_HOME(),
	CALL_NATIVE( bhv_platform_normals_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_tilting_inverted_pyramid_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvBitfsSinkingPlatforms[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_bitfs_geo_000770_0x1021528),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_bitfs_sinking_platform_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvBitfsSinkingCagePlatform[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 1),
	LOAD_COLLISION_DATA(col_bitfs_geo_000690_0x1020e84),
	SET_HOME(),
	SPAWN_CHILD(57, 318771200),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_bitfs_sinking_cage_platform_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvActivatedBackAndForthPlatform[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 65),
	SET_HOME(),
	CALL_NATIVE( bhv_activated_back_and_forth_platform_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_activated_back_and_forth_platform_update),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvSquishablePlatform[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 73),
	LOAD_COLLISION_DATA(col_bitfs_geo_000708_0x1020fdc),
	SET_FLOAT(oCollisionDistance, 10000),
	CALL_NATIVE( bhv_platform_normals_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_squishable_platform_loop),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvWfTumblingBridge[] = {
	BEGIN(OBJ_LIST_SPAWNER),
	OR_INT(oFlags, 193),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_tumbling_bridge_loop),
	END_LOOP(),
};

const BehaviorScript bhvSpinAirborneCircleWarp[] = {
	BREAK(),
};

const BehaviorScript bhvTiltingBowserLavaPlatform[] = {
	BEGIN(OBJ_LIST_SURFACE),
	OR_INT(oFlags, 8193),
	LOAD_COLLISION_DATA(col_bowser_2_geo_000170_0x115e0e8),
	SET_FLOAT(oDrawingDistance, 20000),
	SET_FLOAT(oCollisionDistance, 20000),
	SET_INT(oFaceAngleYaw, 0),
	SET_HOME(),
	BEGIN_LOOP(),
		CALL_NATIVE( cur_obj_rotate_face_angle_using_vel),
		CALL_NATIVE( load_object_collision_model),
	END_LOOP(),
};

const BehaviorScript bhvBowserBomb[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 1),
	SET_INT(oIntangibleTimer, 0),
	SET_HITBOX_WITH_OFFSET(40, 40, 40),
	DELAY(1),
	BEGIN_LOOP(),
		SET_INT(oIntangibleTimer, 0),
		CALL_NATIVE( bhv_bowser_bomb_loop),
	END_LOOP(),
};

const BehaviorScript bhvBowser[] = {
	BEGIN(OBJ_LIST_GENACTOR),
	OR_INT(oFlags, 9417),
	SET_INT(oInteractType, 2),
	SET_HITBOX(400, 400),
	DROP_TO_FLOOR(),
	SET_HOME(),
	LOAD_ANIMATIONS(10022, 101021664),
	SPAWN_CHILD(0, 318773452),
	SPAWN_CHILD(101, 318773508),
	SPAWN_OBJ(0, 318773288),
	SET_INT(oNumLootCoins, 50),
	SET_OBJ_PHYSICS(0, 65136, 65466, 1000, 1000, 200, 0, 0),
	SET_HOME(),
	CALL_NATIVE( bhv_bowser_init),
	BEGIN_LOOP(),
		CALL_NATIVE( bhv_bowser_loop),
	END_LOOP(),
};

